/*
 * Decompiled with CFR 0.152.
 */
package cz.insophy.inplan.util.io;

import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import cz.insophy.inplan.util.io.TokenResolver;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CombinedTokenResolver
implements TokenResolver {
    private static final Logger log = LoggerFactory.getLogger(CombinedTokenResolver.class);
    private final List<TokenResolver> resolvers;

    public CombinedTokenResolver(List<TokenResolver> resolvers) {
        HashSet<String> allKeys = Sets.newHashSet();
        int keyNumSum = 0;
        int resolverIdx = 0;
        ArrayList<TokenResolver> nonNullResolvers = Lists.newArrayList();
        for (TokenResolver resolver : resolvers) {
            if (resolver == null) {
                log.warn("Resolver at idx " + resolverIdx + " is null. Ignoring.");
                continue;
            }
            nonNullResolvers.add(resolver);
            ImmutableSet<String> keys = resolver.getAllKeys();
            allKeys.addAll(keys);
            keyNumSum += keys.size();
        }
        if (keyNumSum > allKeys.size()) {
            log.warn("The token space of the subresolvers is overlapping - there are some tokens resolved by more than one resolver.");
        }
        this.resolvers = nonNullResolvers;
    }

    @Override
    public String resolveToken(String tokenName) {
        for (TokenResolver resolver : this.resolvers) {
            if (!resolver.isTokenResolved(tokenName)) continue;
            return resolver.resolveToken(tokenName);
        }
        return null;
    }

    @Override
    public boolean isTokenResolved(final String tokenName) {
        return !Collections2.filter(this.resolvers, new Predicate<TokenResolver>(){

            @Override
            public boolean apply(@Nullable TokenResolver input) {
                return input.isTokenResolved(tokenName);
            }
        }).isEmpty();
    }

    @Override
    public ImmutableSet<String> getAllKeys() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (TokenResolver resolver : this.resolvers) {
            builder.addAll(resolver.getAllKeys());
        }
        return builder.build();
    }
}

